import os
import gradio as gr
from transformers import pipeline


def blog_gen(txt):
    generator=pipeline(task='text-generation',model='gpt2')
    gen_blog=generator(txt,max_length=300,num_return_sequences=2)
    remove_gen_text = list(map(lambda x: x["generated_text"], gen_blog))
    clean_text = list(map(lambda x: x.replace("\n\n", " "), remove_gen_text))
    return clean_text


iface = gr.Interface(fn=blog_gen,
                     inputs=[
                         gr.inputs.Textbox(
                             lines=2, placeholder=None, label='Sentence'),
                     ],
                     outputs=[gr.outputs.JSON(label=None)])
iface.launch()