import gradio as gr
from transformers import pipeline


def trnslt(TagalogText,Language):
  txt_inp = gr.Interface.load("huggingface/Helsinki-NLP/opus-mt-tl-en")
  if Language=="Cebuano":
    ceb1 = gr.Interface.load("huggingface/Helsinki-NLP/opus-mt-en-ceb")
    out_ceb = gr.Series(txt_inp,ceb1)
    return out_ceb(TagalogText)
  elif Language=="Ilocano":
    ilo1 = gr.Interface.load("huggingface/Helsinki-NLP/opus-mt-en-ilo")
    out_ilo = gr.Series(txt_inp,ilo1)
    return out_ilo(TagalogText)
  elif Language=="Hiligaynon":
    hil1 = gr.Interface.load("huggingface/Helsinki-NLP/opus-mt-en-hil")
    out_hil = gr.Series(txt_inp,hil1)
    return out_hil(TagalogText)

iface = gr.Interface(
  fn=trnslt, 
  inputs=[gr.inputs.Textbox(label="Input Tagalog Text"),
  gr.inputs.Radio(["Cebuano","Ilocano","Hiligaynon"],label="Translate to",optional=False)],
  outputs='text',
  examples=[["Magandang Umaga","Cebuano"],["Magandang gabi","Ilocano"],["Masarap ang Adobo","Hiligaynon"],
  ["Kumusta Ka Na","Cebuano"],["Bumibili si Juan ng  manok","Ilocano"],["Magandang umaga","Hiligaynon"]],
  live=True,
  theme="dark-seafoam",
  title="Basic Filipino Dialect Translator",
  description="                           This application uses Helsinki-NLP models to translate Tagalog texts to 3 other dialects of the Filipino language",
  css=".footer{display:none !important}", 
)

iface.launch()


