#Librerias para cargar imagenes
import numpy as np
import tensorflow as tf
from tensorflow.keras.preprocessing.image import load_img, img_to_array
from tensorflow.keras.models import load_model
from PIL import Image
import streamlit as st

dim = 200
modelo = './modelo.h5'
pesos = './pesos.h5'
cnn = load_model(modelo)
cnn.load_weights(pesos)

def clasificar(file):
  x = load_img(file, target_size=(dim, dim), color_mode = "grayscale")
  x = img_to_array(x)
  x = np.expand_dims(x, axis=0)
  arreglo = cnn.predict(x)
  resultado = arreglo[0]
  respuesta = np.argmax(resultado)
  rta = ""

  if respuesta==0:
    rta = 'NORMAL'
  else:
    rta = 'TUMOR CEREBRAL'

  return rta

st.title("CNN Clasificador de Casos de Cancer Cerebral")
uploaded_file = st.file_uploader("Sube una imagen...", type="jpg")
if uploaded_file is not None:
    image = Image.open(uploaded_file)
    st.image(image, caption='Uploaded Image.', use_column_width=True)
    st.write("")
    st.write("Clasificacion:")
    label = clasificar("./test/"+uploaded_file.name) ##aqui va el llamado a la IA
    st.write(label)