from TTS.api import TTS
from bs4 import BeautifulSoup
import requests
import streamlit as st
import tempfile
import os
import json
import datetime

with open('config.json', 'r') as f:
    config = json.load(f)

APP_NAME = config['APP_NAME']
APP_LOGO = config['APP_LOGO']
APP_DESCRIPTION = config['APP_DESCRIPTION']

def contains_only_ascii(input_string):
    return all(ord(char) < 128 for char in input_string)

def create_temp_file(input_wav):
    temp_file = tempfile.NamedTemporaryFile(delete=False)
    temp_file.write(input_wav.read())
    return temp_file

def remove_temp_file(temp_file):
    temp_file.close()
    os.remove(temp_file.name)

def update_progress(percent, text):
    progress_bar.progress(percent)
    status_text.text(text)

st.set_page_config(page_title=APP_NAME)
st.title(APP_NAME)
st.image(APP_LOGO, use_column_width=True)
st.markdown(APP_DESCRIPTION)

input_wav = st.file_uploader("Upload a WAV file with your voice", type=["wav"])
clone_wav = st.file_uploader("Upload a WAV file with voice to clone", type=["wav"])

if input_wav and clone_wav:
    progress_bar = st.progress(0)
    status_text = st.empty()

    current_datetime = datetime.datetime.now()
    formatted_datetime = current_datetime.strftime("%Y-%m-%d_%H%M%S")
    output_filename = f"recording_{formatted_datetime}.wav"

    temp_input_file = create_temp_file(input_wav)
    temp_clone_file = create_temp_file(clone_wav)

    update_progress(0, 'Loading TTS model...')
    api = TTS("voice_conversion_models/multilingual/vctk/freevc24")

    update_progress(50, 'Generating audio...')
    api.voice_conversion_to_file(
        source_wav=temp_input_file.name,
        target_wav=temp_clone_file.name,
        file_path=output_filename
    )

    remove_temp_file(temp_input_file)
    remove_temp_file(temp_clone_file)

    audio_file = open(output_filename, 'rb')
    audio_bytes = audio_file.read()

    update_progress(100, 'Audio generated successfully!')

    st.audio(audio_bytes, format='audio/wav')

    st.download_button('Download WAV', data=audio_bytes, file_name='output.wav')