import gradio as gr
from fastai.vision.all import *
import pathlib
plt = platform.system()
if plt == 'Windows': pathlib.PosixPath = pathlib.WindowsPath

def is_cat(x): return x[0].isupper()

def greet(name):
    return "Hello " + name + "!!"

learn = load_learner('is_cat_model.pkl')


categories = ('Dog','Cat')

def classify_image(img):
    pred,idx,probs = learn.predict(img)
    return dict(zip(categories,map(float,probs)))

image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()
examples = ['dog.jpg','cat.jpg','dunno.jpg']

intf = gr.Interface(fn=classify_image, inputs = image, outputs= label, examples = examples, theme=gr.themes.Soft())

intf.launch(inline=False)

