import gradio as gr
import openai
import os
openai.api_key = os.environ['key3']

def answer_query(prompt):
    response = openai.Completion.create(
      engine="text-davinci-003",
      prompt=prompt,
      max_tokens=150
    )
    message = response.choices[0].text.strip()
    
    # Check if query is parrot-related
    if 'parrot' not in prompt.lower():
        return "This service is only for parrot-related queries."

    # Disclaimer for vet info
    if 'vet' in prompt.lower() or 'veterinarian' in prompt.lower() or 'medical' in prompt.lower():
        return f"{message}\n\nPlease note that while I strive to provide accurate information, I'm an AI and not a veterinarian. Always consult with a professional for medical advice."
    
    return message

iface = gr.Interface(fn=answer_query, inputs="text", outputs="text")
iface.launch()
