import pickle
import openai
#from flask import redirect, render_template, request, url_for
import gradio as gr

# with   open("apikey.pkl", "rb") as f:
#     apikey  = pickle.load(f)
# print(apikey)

def get_open_ai_output(recipe_titles):
    with open("apikey.pkl", "rb") as f:
        apikey  = pickle.load(f)
        openai.api_key = apikey
        response = openai.Completion.create(
            model="text-davinci-003",
            prompt=generate_prompt(recipe_titles),
            temperature=0.98,
            max_tokens = 4000
            )
        response = response.choices[0].text
    return response



def generate_prompt(recipe_titles):
    return """Suggest a recipe title based on the food item inputted, then acting as a cookbook give the full recipe for the title suggested, include ingredients and instructions

Example:

Food: {}
Titles:""".format(
        recipe_titles.capitalize()
    )
    
#@app.route("/", methods=("GET", "POST"))
# def index():
#     if request.method == "POST":
#         recipe_titles = request.form["recipe_titles"]
#         response = openai.Completion.create(
#             model="text-davinci-003",
#             prompt=generate_prompt(recipe_titles),
#             temperature=0.98,
#             max_tokens = 4000
#         )
#         return redirect(url_for("index", result=response.choices[0].text))

#     result = request.args.get("result")
#     return render_template("index.html", result=result)

#io1 = gr.Interface.load("huggingface/openai-gpt")

#io2 = gr.Interface.load("huggingface/CoffeeAddict93/gpt1-modest-proposal")

def inference(recipe_titles):
        output = get_open_ai_output(recipe_titles)
        return output
input = gr.Textbox(label="Food Ingredient",max_lines=1, placeholder = "Enter ONE food ingredient here")
output = gr.Textbox(label="Recipe")

with gr.Blocks(css = ".gradio-container {background-color: #E7ECF3}") as demo:

    gr.Interface(
        inference,
        input,output,title = """
                
                     # **<span style="color:#3526A">Something Sweet...</span>**
                
                    """ , 
                    description = "**Generate different recipes from just ONE ingredient!**", allow_flagging="never")
    gr.Examples(
        [["Milk"], ["Butter"]],
        input, output,
        inference,
        cache_examples= False)
demo.launch(enable_queue=True)


