import streamlit as st
from transformers import pipeline

model = pipeline("question-answering", model="/home/user/app/MendoBERT/", tokenizer="indolem/indobert-base-uncased")
basemodel = pipeline("question-answering", model="/home/user/app/IndoLEM/", tokenizer="indolem/indobert-base-uncased")

st.title(':blue[MendoBERT] - Question Answering 🤔 💭')

if 'context' not in st.session_state:
    st.session_state['options'] = ""

if 'question' not in st.session_state:
    st.session_state['options'] = ""

def button1_callback():
    st.session_state['context'] = "Acrokeratosis paraneoplastica (Sindrom Bazex) dengan karsinoma sel skuamosa orofaringeal. Seorang pria kulit putih berusia 65 tahun menunjukkan semua gambaran klinis akrokeratosis paraneoplastica dari Bazex, ditandai dengan eritema keunguan dan penskalaan hidung, heliks aural, jari tangan, dan kaki, dengan keratoderma dan distrofi kuku yang parah. Pemeriksaan pasien untuk kemungkinan keganasan terkait mengungkapkan karsinoma sel skuamosa asimtomatik di daerah orofaringeal. Lesi kulit sembuh hampir seluruhnya setelah terapi radiasi neoplasma, tetapi onikodistrofi tetap ada. Laporan kasus ini menggambarkan pentingnya pengenalan dini sindrom Bazex."
    st.session_state['question'] = "Nama sinonim dari Acrokeratosis paraneoplastica."

def button2_callback():
    st.session_state['context'] = "Hingga saat ini, jumlah faktor genetik molekuler yang secara tegas terkait dengan tumor hipofisis dapat dihitung dengan jari: (1) aktivasi GNAS1 pada akromegali; (2) mutasi MENIN dan p27Kip1 (CDKN1B) yang terkait dengan neoplasia endokrin multipel tipe 1; (3) mutasi PRKA1RA dengan hilangnya 17q22-24 di kompleks Carney, dan (4) mutasi gen reseptor hidrokarbon aril yang berinteraksi protein pada 15% adenoma hipofisis terisolasi familial dan 50% akromegali terisolasi familial"
    st.session_state['question'] = "Mutasi gen mana yang terlibat dalam adenoma hipofisis terisolasi familial?"

context_placeholder = st.empty()
with context_placeholder:
    context = st.text_area('Enter context: ', key = 'context')

question_placeholder = st.empty()
with question_placeholder:
    question = st.text_area('Enter question: ', key = 'question')

st.caption('_Examples_')
st.button('Context: \n\n Acrokeratosis paraneoplastica (Sindrom Bazex) dengan karsinoma sel skuamosa orofaringeal. Seorang pria kulit putih berusia 65 tahun menunjukkan semua gambaran klinis akrokeratosis paraneoplastica dari Bazex, ditandai dengan eritema keunguan dan penskalaan hidung, heliks aural, jari tangan, dan kaki, dengan keratoderma dan distrofi kuku yang parah. Pemeriksaan pasien untuk kemungkinan keganasan terkait mengungkapkan karsinoma sel skuamosa asimtomatik di daerah orofaringeal. Lesi kulit sembuh hampir seluruhnya setelah terapi radiasi neoplasma, tetapi onikodistrofi tetap ada. Laporan kasus ini menggambarkan pentingnya pengenalan dini sindrom Bazex. \n\n\n Question: \n\n Nama sinonim dari Acrokeratosis paraneoplastica. \n\n\n Expected Answer: \n\n Sindrom Bazex', use_container_width=True, on_click = button1_callback)
st.button('Context: \n\n Hingga saat ini, jumlah faktor genetik molekuler yang secara tegas terkait dengan tumor hipofisis dapat dihitung dengan jari: (1) aktivasi GNAS1 pada akromegali; (2) mutasi MENIN dan p27Kip1 (CDKN1B) yang terkait dengan neoplasia endokrin multipel tipe 1; (3) mutasi PRKA1RA dengan hilangnya 17q22-24 di kompleks Carney, dan (4) mutasi gen reseptor hidrokarbon aril yang berinteraksi protein pada 15% adenoma hipofisis terisolasi familial dan 50% akromegali terisolasi familial \n\n\n Question: \n\n Mutasi gen mana yang terlibat dalam adenoma hipofisis terisolasi familial? \n\n\n Expected Answer: \n\n reseptor hidrokarbon aril yang berinteraksi protein', use_container_width=True, on_click = button2_callback)

if context and question:
    st.subheader('MendoBERT')
    st.write(model(context=context, question=question))
    st.write("\n")
    st.subheader('IndoLEM')
    st.write(basemodel(context=context, question=question))