import gradio as gr
import openai

# Function to extract the last statement from the input
def extract_last_statement(input_text):
    lines = input_text.strip().split('\n')
    last_line = lines[-1]
    last_statement = last_line.split(':')[-1].strip() if ':' in last_line else last_line
    return last_statement

def yes_and_game(api_key, user_input):
    # Initialize OpenAI API client
    openai.api_key = api_key

    # Extract the last statement from the user input
    last_statement = extract_last_statement(user_input)

    # Create the prompt for GPT
    gpt_prompt = (f"Play the Yes, And improv game. "
                  f"You will start your response with 'Yes, and'. "
                  f"Keep your responses short. Not more than one statement. Responses can be funny or absurd. "
                  f"The input statement can be a single line or a multi line statement.\n"
                  f"Yes, And {last_statement}\n"
                  f"Yes, And ")

    # Generate GPT response
    gpt_response = openai.Completion.create(
        engine="text-davinci-002",
        prompt=gpt_prompt,
        max_tokens=20,  
        temperature=0.9  # Increased temperature for more randomness
    )['choices'][0]['text'].strip()

    # Format and return the result
    result = f"{last_statement}\nYes, And {gpt_response}"
    return result

iface = gr.Interface(
    fn=yes_and_game,
    inputs=[
        gr.Textbox(label="OpenAI API Key", type="password"),
        gr.Textbox(lines=5, label="Statement"),
    ],
    outputs=gr.Textbox(label="Game Transcript", live=True, flagging=True),  # Setting live=True for real-time updates, flagging=True to allow copying
    title="The Yes, And Game"  # Adding title here
)


# This will create a link to host your model on Hugging Face Spaces when executed
iface.launch(share=True)
