import gradio as gr
import random
from datasets import load_dataset

# Load the dataset from Hugging Face
dataset = load_dataset("Blessin/dialogues-one-liners")

# Extract the dialogues from the dataset
DIALOGUES = dataset["train"]["dialogues"]

def generate_statement():
    """Return a random dialogue from the dataset."""
    # Pick a random sublist from the dataset
    random_dialogue_list = random.choice(DIALOGUES)
    # Pick a random dialogue from the sublist
    return random.choice(random_dialogue_list)


def main():
    # Define the UI using gr.Interface
    interface = gr.Interface(
        fn=generate_statement,  # Function to call on button press
        inputs=[],              # No inputs required
        outputs="text",         # Output is a text area
        live=False,             # Only generate statement after button press
        description="Press the button to generate a random statement from the dataset."
    )
    
    # Launch the UI
    interface.launch(share=True)

if __name__ == "__main__":
    main()
