import gradio as gr
from gradio import components
import openai
from PIL import Image, ImageDraw
import requests
from io import BytesIO

genre_descriptions = {
    "Horror": "Dark, eerie, and suspenseful ambiance.",
    "Sci-Fi": "Futuristic, technological, and other-worldly themes.",
    "Romance": "Warm, tender, and emotionally evocative imagery.",
    "Adventure": "Exhilarating, action-packed, and exploratory vibes.",
    "Comedy": "Light-hearted, whimsical, and humorous elements.",
    "Drama": "Intense, emotional, and thought-provoking scenarios.",
    "Fantasy": "Magical, mythical, and dream-like settings.",
    "Action": "Dynamic, high-energy, and thrilling scenes.",
    "Mystery": "Intriguing, puzzling, and enigmatic atmosphere.",
    "Thriller": "Tense, exciting, and adrenaline-inducing compositions.",
}

def generate_poster(api_key, genre, title):
    openai.api_key = api_key
    genre_description = genre_descriptions.get(genre, "")
    prompt = (f"Create a visually striking movie poster for a {genre} film titled '{title}'. "
              f"The poster should encapsulate the essence and atmosphere of a typical {genre} movie, "
              f"without including any text or titles. The design should be original, imaginative and "
              f"should instantly communicate the genre to the viewer. {genre_description}")
    
    response = openai.Image.create(
        prompt=prompt,
        n=1,
        size="1024x1024"
    )
    image_url = response['data'][0]['url']
    response = requests.get(image_url)
    img = Image.open(BytesIO(response.content))

    return img

def main():
    genre_options = [
        "Horror", "Sci-Fi", "Romance", "Adventure", 
        "Comedy", "Drama", "Fantasy", "Action", 
        "Mystery", "Thriller"
    ]
    iface = gr.Interface(
        fn=generate_poster,
        inputs=[
            components.Textbox(label="API Key", type="password"),
            components.Dropdown(label="Genre", choices=genre_options),
            components.Textbox(label="Title", placeholder="e.g., 'The Haunting Shadows'")
        ],
        outputs=components.Image(label="Generated Poster", type="pil"),
    )
    iface.launch()

if __name__ == "__main__":
    main()
