import gradio as gr
import openai

def generate_script(api_key, name1, name2, situation):
    # Initialize OpenAI API with the provided key
    openai.api_key = api_key

    # Define the example script to set the context
    example_script = (
         "Setting: A cafe\n\n"
        "Scene:\n\n"
        "(Lights come up on a cozy little coffee shop. LOUIS and GIRL are sitting at a small table, with two untouched coffees between them. "
        "It's clear from their expressions that the awkwardness from the previous scene hasn't worn off.)\n\n"
        "LOUIS. (Attempting to break the ice) So, um... do you come to this coffee shop often?\n"
        "GIRL. (Coldly) No, not really.\n"
        "LOUIS. Oh. Well, they have the best almond croissants here. You should try one, sometime.\n"
        "GIRL. (Slightly warming up) I'm more of a bagel person, actually.\n"
        "LOUIS. Really? Me too! What's your favorite kind?\n"
        "GIRL. Plain. With cream cheese.\n"
        "LOUIS. Nice choice. I like mine with a bit of jam.\n"
        "(A brief pause as they both sip their coffee, seemingly more at ease.)\n\n"
        "LOUIS. (Hesitant) Look, I'm sorry about earlier... I don't know why I was acting like such a jerk.\n"
        "GIRL. (Softening) It's alright. People can act strange when they meet someone new.\n"
        "LOUIS. Yeah. It's just... I've been feeling kind of... out of place lately. And I guess I was trying too hard to impress you.\n"
        "GIRL. You don't have to impress me, Louis. Just be yourself.\n"
        "(LOUIS smiles shyly and looks down at his coffee. The GIRL does too, and for a moment, there's a comfortable silence between them.)\n\n"
        "LOUIS. So... do you have any plans for the weekend?\n"
        "GIRL. (Smiling) Not much. Just taking my dog to the park. Maybe catch a movie later. How about you?\n"
        "LOUIS. Same here. Minus the dog, though.\n"
        "GIRL. (Laughs) Well, maybe you can join me. And who knows, you might just enjoy the simple joy of a walk in the park.\n"
        "LOUIS. (Smiling) I'd like that.\n\n"
        "(As they continue chatting, the lights dim, suggesting the budding of a new connection between LOUIS and GIRL.)\n\n"
        "(Blackout)\n"
    )

    # Define the prompt to transform the user's inputs into a stage play script
    prompt_text = (
        f"{example_script}\n\n"
        f"Generate a new stage play script based on the following details:\n"
        f"Location: Cafe\n"
        f"Character 1: {name1}\n"
        f"Character 2: {name2}\n"
        f"Situation: {situation}\n"
    )

    # Use OpenAI's Completion endpoint to generate the stage play script
    response = openai.Completion.create(engine="davinci", prompt=prompt_text, max_tokens=500)
    script = response.choices[0].text.strip()

    return script

# Define Gradio Interface
iface = gr.Interface(
    fn=generate_script,
    inputs=[
        gr.components.Textbox(label="OpenAI API Key", type="password"),
        gr.components.Textbox(label="Name 1", type="text"),
        gr.components.Textbox(label="Name 2", type="text"),
        gr.components.Textbox(label="Situation", type="text"),
    ],
    outputs=gr.components.Textbox(label="Generated Stage Play Script", type="text"),
    live=True,
    title="Stage Play Script Generator",
    description="Generate a stage play script set in a cafe based on given characters and situation using OpenAI!",
    progress="Generating stage play script...",
)

# Launch the Gradio app
iface.launch()
