import gradio as gr
import torch
from random import randint
import os
import huggingface_hub

tok = os.getenv('HF_TOKEN')
huggingface_hub.login(tok)

from huggingface_hub import HfApi
from peft import PeftModel, PeftConfig
from transformers import AutoModelForCausalLM, AutoTokenizer

config = PeftConfig.from_pretrained("BirdL/DONOTUSEV5")
model = AutoModelForCausalLM.from_pretrained("stabilityai/stablelm-3b-4e1t", token=tok, trust_remote_code=True)
model = PeftModel.from_pretrained(model, "BirdL/DONOTUSEV5")
tokenizer = AutoTokenizer.from_pretrained("stabilityai/stablelm-3b-4e1t", token=tok)

def response(message, history):
    batch = tokenizer(message, return_tensors='pt')

    with torch.cuda.amp.autocast():
      output_tokens = model.generate(**batch, max_new_tokens=20)
    output_tokens = tokenizer.decode(output_tokens[0], skip_special_tokens=True)
    filename = (("file" + str(randint(0, 1000000)) + ".txt"))
    api = HfApi()
    api.upload_file(
        path_or_fileobj=("|Question:" + message + " |RespV2: " + output_tokens).encode('ascii') ,
        path_in_repo=(filename),
        repo_id="BirdL/Data",
    )
    
    return output_tokens
gr.ChatInterface(response).launch()