from transformers import pipeline
import gradio as gr
def story(StoryLength,StoryPrompt):
    model= pipeline("text-generation", model="e-tony/gpt2-rnm")
    summarizer = pipeline("summarization", model="facebook/bart-large-cnn")
    return model(StoryPrompt, max_length=200, num_return_sequences=3)[2]["generated_text"],summarizer(model(StoryPrompt, max_length=200, num_return_sequences=3)[2]["generated_text"], max_length=StoryLength, min_length=30, do_sample=False)[0]["summary_text"]
    
    
interface = gr.Interface(fn=story, 
                        inputs=["number","text"],
                        outputs=[gr.inputs.Textbox(label='GPT2 Output'),gr.inputs.Textbox(label='Output summary')], 
                        title='Bilal\'s Story Generator')
                        

interface.launch(inline=False)
