
from cv2 import threshold
import keras_ocr
import cv2
import math
import numpy as np
import gradio as gr

def midpoint(x1, y1, x2, y2):
    x_mid = int((x1 + x2)/2)
    y_mid = int((y1 + y2)/2)
    return (x_mid, y_mid)

def segment_img(img):
    hsv=cv2.cvtColor(img,cv2.COLOR_RGB2HSV)
    #mask
    mask=cv2.inRange(hsv,(40,25,25),(70,255,255))
    
    imask=mask>0
    threshold=np.zeros_like(img,np.uint8)
    threshold[imask]=img[imask]
    
    return threshold
#Main function that detects text and inpaints. 
#Inputs are the image path and kreas_ocr pipeline
def inpaint_text(img_path, pipeline):
    # read the image 
    img = keras_ocr.tools.read(img_path) 
    
    #img=segment_img(img)
    
    
    # Recogize text (and corresponding regions)
    # Each list of predictions in prediction_groups is a list of
    # (word, box) tuples. 
    prediction_groups = pipeline.recognize([img])
    
    #Define the mask for inpainting
    mask = np.zeros(img.shape[:2], dtype="uint8")
    for box in prediction_groups[0]:
        x0, y0 = box[1][0]
        x1, y1 = box[1][1] 
        x2, y2 = box[1][2]
        x3, y3 = box[1][3] 
        
        x_mid0, y_mid0 = midpoint(x1, y1, x2, y2)
        x_mid1, y_mi1 = midpoint(x0, y0, x3, y3)
        
        #For the line thickness, we will calculate the length of the line between 
        #the top-left corner and the bottom-left corner.
        thickness = int(math.sqrt( (x2 - x1)**2 + (y2 - y1)**2 ))
        
        #Define the line and inpaint
        cv2.line(mask, (x_mid0, y_mid0), (x_mid1, y_mi1), 255,    
        thickness)
        inpainted_img = cv2.inpaint(img, mask, 7, cv2.INPAINT_NS)
                 
    return (inpainted_img)

# keras-ocr will automatically download pretrained
# weights for the detector and recognizer.
pipeline = keras_ocr.pipeline.Pipeline()
def RemoveText(image):
    img_text_removed = inpaint_text(image, pipeline)
    return  cv2.cvtColor(img_text_removed, cv2.COLOR_BGR2RGB)

iface = gr.Interface(fn=RemoveText,
             inputs=gr.inputs.Image(label="Image to Remove Text From", type="numpy"),
             outputs="image",
                    examples=[["1.jpg"]],
                    title="Remove Text for Image")
iface.launch(debug=True)

