import numpy as np
import cv2
import os
import gradio as gr
def get_mean_and_std(x):
	x_mean, x_std = cv2.meanStdDev(x)
	x_mean = np.hstack(np.around(x_mean,2))
	x_std = np.hstack(np.around(x_std,2))
	return x_mean, x_std

def ApplyChange(image1,image2):
    #template_img = cv2.imread(image1)
    template_img = cv2.cvtColor(image1,cv2.COLOR_BGR2LAB)
    template_mean, template_std = get_mean_and_std(template_img)
    
    # for img in (input_image_list):
    #     print(img)
        #input_img = cv2.imread(input_dir+img)
    #input_img = cv2.imread(image2)    
    input_img = cv2.cvtColor(image2,cv2.COLOR_BGR2LAB)
    
    
    img_mean, img_std = get_mean_and_std(input_img)
    
    
    height, width, channel = input_img.shape
    for i in range(0,height):
        for j in range(0,width):
            for k in range(0,channel):
                x = input_img[i,j,k]
                x = ((x-img_mean[k])*(template_std[k]/img_std[k]))+template_mean[k]
                x = round(x)
                # boundary check
                x = 0 if x<0 else x
                x = 255 if x>255 else x
                input_img[i,j,k] = x
            
    input_img= cv2.cvtColor(input_img,cv2.COLOR_LAB2BGR)
    return input_img

iface = gr.Interface(fn=ApplyChange,
             inputs=[gr.inputs.Image(label="Image to Transfer Color", type="numpy"),gr.inputs.Image(label="Image to Tranfer Color on", type="numpy")],
             outputs="image",
                    examples=[["cherry-blossom.jpg","road.jpg"]],
                    title="Reinhard Color Transformation")

iface.launch(debug=True)
