import pytesseract
from PIL import Image
import requests
import json
import numpy as np
import gradio as gr
import os 



def get_halal_data(ingredient, num_results=20):

  try:
    url = f'http://halal.addi.is.its.ac.id/apiv2?q={ingredient}&result={num_results}'
    response = requests.get(url)
    data = response.json()  
  except requests.exceptions.RequestException as e:
    print(f"Error: {e}")
    return None

  results = []

  for result in data['entityData']:
    try:
      if result['atribute']['certificate']:
        results.append(result)
    except:
      pass
  
  if not results:
    return "No Data Found If its halal"

  return results



def extract_text(text,image):
  # Convert sketchpad to bounding box
  # img1 = np.array(Image.fromarray(image))
  if text=='':
      text = pytesseract.image_to_string(image)
  # Extract ingredient words
  # ingredients = [word for word in text.split() if word.isalpha()]

  # results = {}

  # for ing in ingredients:
  #   data = get_halal_data(ing, 5)
  #   if data:
  #     results[ing] = data
  #   else:
  #     results[ing] = "No halal data found"
  try:
      results=get_halal_data(text,5)
  except:
      pass

  return text,results

iface = gr.Interface(fn=extract_text,
             inputs=["text",gr.inputs.Image(label="image", type="numpy")],
             outputs=["text","text"],
                    examples=[["Monosodium Glutamate",None],[None,"3.jpg"]],
                    title="Halal Food Checker",
                    description="Enter products, ingredients, foodcodes, or manufactures manually or upload image and crop it to ingredient. If a data is shown for an ingredient its mean its Halal.")

iface.launch(debug=True)