import os
os.system('pip install tensorflow')
import tensorflow as tf
from tensorflow import keras
import numpy as np
import gradio as gr

tokenizer = tf.keras.preprocessing.text.Tokenizer()

#Reads Text Inputs Here
f=open('Inputs.txt','r')
inputs = f.read().split('\n')
f.close()

corpus = inputs

tokenizer.fit_on_texts(corpus)
sequences = tokenizer.texts_to_sequences(corpus)

max_length = max([len(s) for s in sequences])

# Load your saved model
model = tf.keras.models.load_model('sentiment_mini-test')

model.summary()

def use(input_text):
  # Preprocess the input text
  sequences = tokenizer.texts_to_sequences([input_text])
  sequences = tf.keras.preprocessing.sequence.pad_sequences(sequences, padding='post', maxlen=max_length)

  # Make a prediction on the input text
  prediction = model.predict(sequences)[0]

  # Print the prediction
  if prediction[0]<0.3:
      return "That's Negative! (" + str(round(round(1-prediction[0],2)*100,1)) + "% confidence)", prediction[0]
  elif prediction[0]>0.3:
      return "That's Positive! (" + str(round(round(prediction[0],2)*100,1)) + "% confidence)", prediction[0]
  else:
      return "That's Neutral!", prediction[0]


iface = gr.Interface(fn=use, 
                     inputs=gr.Textbox(lines=8, placeholder="Type Something Awesome..."), 
                     outputs=[gr.Textbox(lines=3, placeholder="Waiting For Magic..."),"number"],
                     title="Use RSA (Review Sentiment Analysis) v0.1.2",
                     description="<center>This is an NLP model that accepts a text string as input and simply outputs if the string is mean or nice with about 96.5% accuracy. It also provides you with a score of how positive or negative it is.</center>",
                     article="\nRSA v0.1.2: @2.3M Params w/ 96.5% acc. & 388MB input dataset + 1.59MB output dataset. Trained on <a href='https://www.kaggle.com/datasets/ilhamfp31/yelp-review-dataset'>this Kaggle dataset</a>",
                     examples=[
                     ["I went there today! The cut was terrible! I have an awful experience. They lady that cut my hair was nice but she wanted to leave early so she made a disaster in my head!"],
                     ["Yes! Awesome soy cap, scone, and atmosphere. Nice place to hang out & read, and free WiFi with no login procedure."],
                     ["Overpriced, salty and overrated!!! Why this place is so popular I will never understand."],
                     ["This Valentines Day I ordered a pizza for my boyfriend and asked that they make a heart on it out of green peppers. The pizza was great, the heart was perfect, and he loved it!"]
                     ])
iface.launch()
