from deep_translator import GoogleTranslator
import streamlit as st

st.set_page_config(page_title='Language Translator (Adaptation of https://github.com/Ompramod9921/Language_translator)')

hide_streamlit_style = """
            <style>
            #MainMenu {visibility: hidden;}
            footer {visibility: hidden;}
            footer:after {
            content: 'Adaptation of https://github.com/Ompramod9921/Language_translator (om pram)' 
            visibility: visible;
            }
            </style>
            """
st.markdown(hide_streamlit_style, unsafe_allow_html=True)

st.markdown("<h1 style='text-align: center; font-size: 24px; color: voilet;font-family: Droid Sans'>Language Translator (Adaptation of https://github.com/Ompramod9921/Language_translator)</h1>", unsafe_allow_html=True)
st.write("****")

text = st.text_area("Enter text:",height=None,max_chars=None,key=None,help="Enter your text here -")
st.write("****")

option1 = st.selectbox('Input language',('english','hindi','afrikaans', 'albanian', 'amharic', 'arabic', 'armenian', 'azerbaijani', 'basque', 'belarusian', 'bengali', 'bosnian', 'bulgarian', 'catalan', 'cebuano', 'chichewa', 'chinese', 'chinese (simplified)', 'chinese (traditional)', 'corsican', 'croatian', 'czech', 'danish', 'dutch', 'esperanto', 'estonian', 'filipino', 'finnish', 'french', 'frisian', 'galician', 'georgian', 'german', 'greek', 'gujarati', 'haitian creole', 'hausa', 'hawaiian', 'hebrew', 'hmong', 'hungarian', 'icelandic', 'igbo', 'indonesian', 'irish', 'italian', 'japanese', 'javanese', 'kannada', 'kazakh', 'khmer', 'korean', 'kurdish (kurmanji)', 'kyrgyz', 'lao', 'latin', 'latvian', 'lithuanian', 'luxembourgish', 'macedonian', 'malagasy', 'malay', 'malayalam', 'maltese', 'maori', 'marathi', 'mongolian', 'myanmar (burmese)', 'nepali', 'norwegian', 'pashto', 'persian', 'polish', 'portuguese', 'punjabi', 'romanian', 'russian', 'samoan', 'scots gaelic', 'serbian', 'sesotho', 'shona', 'sindhi', 'sinhala', 'slovak', 'slovenian', 'somali', 'spanish', 'sundanese', 'swahili', 'swedish', 'tajik', 'tamil', 'telugu', 'thai', 'turkish', 'ukrainian', 'urdu', 'uzbek', 'vietnamese', 'welsh', 'xhosa', 'yiddish', 'yoruba', 'zulu', 'Filipino'))
option2 = st.selectbox('Output language',('english','hindi','afrikaans', 'albanian', 'amharic', 'arabic', 'armenian', 'azerbaijani', 'basque', 'belarusian', 'bengali', 'bosnian', 'bulgarian', 'catalan', 'cebuano', 'chichewa', 'chinese', 'chinese (simplified)', 'chinese (traditional)', 'corsican', 'croatian', 'czech', 'danish', 'dutch', 'esperanto', 'estonian', 'filipino', 'finnish', 'french', 'frisian', 'galician', 'georgian', 'german', 'greek', 'gujarati', 'haitian creole', 'hausa', 'hawaiian', 'hebrew', 'hmong', 'hungarian', 'icelandic', 'igbo', 'indonesian', 'irish', 'italian', 'japanese', 'javanese', 'kannada', 'kazakh', 'khmer', 'korean', 'kurdish (kurmanji)', 'kyrgyz', 'lao', 'latin', 'latvian', 'lithuanian', 'luxembourgish', 'macedonian', 'malagasy', 'malay', 'malayalam', 'maltese', 'maori', 'marathi', 'mongolian', 'myanmar (burmese)', 'nepali', 'norwegian', 'pashto', 'persian', 'polish', 'portuguese', 'punjabi', 'romanian', 'russian', 'samoan', 'scots gaelic', 'serbian', 'sesotho', 'shona', 'sindhi', 'sinhala', 'slovak', 'slovenian', 'somali', 'spanish', 'sundanese', 'swahili', 'swedish', 'tajik', 'tamil', 'telugu', 'thai', 'turkish', 'ukrainian', 'urdu', 'uzbek', 'vietnamese', 'welsh', 'xhosa', 'yiddish', 'yoruba', 'zulu', 'Filipino'))
st.write("****")

if st.button('Translate Sentence'):
    st.write(" ")
    st.write(" ")
    if text == "":
        st.warning('Please **enter text** for translation')

    else:
        if option1 == option2 :
            st.error("source and target language can't be the same")
        else :
            translated = GoogleTranslator(source=option1,target=option2).translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source=option2,target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))

if st.button('Back Translate: Multiple Languages'):
    st.write(" ")
    st.write(" ")
    if text == "":
        st.warning('Please **enter text** for translation')
    else:
        if option1 == option2 :
            st.error("source and target language can't be the same")
        else:
            translated = GoogleTranslator(source=option1,target=option2).translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source=option2,target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
        
            translated = GoogleTranslator(source=option1,target="albanian").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="albanian",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="greek").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="greek",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="italian").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="italian",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="polish").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="polish",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="spanish").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="spanish",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="galician").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="galician",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))
            
            translated = GoogleTranslator(source=option1,target="dutch").translate(text=text)
            st.write("Translated text -")
            st.info(str(translated))
            translated_text = str(translated)
            back_translated = GoogleTranslator(source="dutch",target=option1).translate(text=translated_text)
            st.write("Back Translated text -")
            st.info(str(back_translated))