from fastbook import *
from fastai.vision.widgets import *
import gradio as gr

learn = load_learner('model/uk_model.pkl')
labels = learn.dls.vocab

def predict(img):
    img = PILImage.create(img)
    pred, pred_idx, probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}

if __name__ == "__main__":
    title = "Bird Breed Classifier"
    description = """A bird breed classifier trained on a dataset of over 200 UK birds with fastai. 
                        This makes it one of the most comprehensive UK bird classifiers available in the world."""
    interpretation='default'
    enable_queue=True

    gr.Interface(fn=predict,
                 inputs=gr.inputs.Image(shape=(512, 512)),
                 outputs=gr.outputs.Label(num_top_classes=3),
                 title=title,
                 description=description,
                 interpretation=interpretation,
                 enable_queue=enable_queue).launch()