from transformers import pipeline
import gradio as gr

pipe = pipeline(model="Bidwill/whisper-small-sanskrit_4")  # change to "your-username/the-name-you-picked"

def transcribe(audio):
    text = pipe(audio)["text"]
    return text

demo = gr.Blocks()

mic_transcribe = gr.Interface(
    fn=transcribe,
    inputs=gr.Audio(source="microphone", type="filepath"),
    outputs="text",
    title="Sanskrit Speech to Text",
    description="Realtime demo for Sanskrit speech recognition.",
)

file_transcribe = gr.Interface(
    fn=transcribe,
    inputs=gr.Audio(source="upload", type="filepath"),
    outputs=gr.outputs.Textbox(),
    title="Sanskrit STT",
    description= "Realtime demo for Sanskrit speech recognition."
)
with demo:
    gr.TabbedInterface(
        [mic_transcribe, file_transcribe],
        ["Transcribe Microphone", "Transcribe Audio File"],
    )

demo.launch()