from fastai.vision.all import *
import gradio as gr 
import pathlib
from contextlib import contextmanager
import pathlib

@contextmanager
def set_posix_windows():
    posix_backup = pathlib.WindowsPath
    try:
        pathlib.WindowsPath = pathlib.PosixPath
        yield
    finally:
        pathlib.WindowsPath = posix_backup

EXPORT_PATH = pathlib.Path("model.pkl")

with set_posix_windows():
    learn = load_learner(EXPORT_PATH)

# learn = load_learner('model.pkl')


categories = ['alligator', 'bee', 'camel', 'cat', 'deer', 'dog', 'dolphin', 'elephant', 'giraffe', 'hamster', 'horse', 'kangaroo', 'lion', 'lizard', 'human', 'owl', 'parrot', 'sheep', 'snake', 'tiger', 'turtle', 'wolf']
def classify_image(img):
    pred,idx,probs = learn.predict(img)
    return dict(zip(categories,map(float,probs)))



image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()
examples = ['cat.jpg','camel.jpg','deer.jpg','dog.jpg','giraffe.jpg','owl.jpg']

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, example=examples)
intf.launch(inline=False)