from sentence_transformers import SentenceTransformer, util
import datasets as ds

import os

ERROR_MESSAGE = "We are sorry, we haven't found the answer to your request."

class Stuff:
    
    def __init__(self):
        
        
        self.datas = ds.load_from_disk(os.path.join("stackexchange_astronomy"))
        self.model = SentenceTransformer('all-MiniLM-L6-v2')
        self.embeddings = [self.model.encode(data['title_body']) for data in self.datas['train']]
        
        
    def most_similar(self, question: str) -> int:
    
        q = self.model.encode(question)
        max_cos_sim = -1

        for i, emb in enumerate(self.embeddings):
            cos_sim = util.cos_sim(emb, q)
            if cos_sim > max_cos_sim:
                max_cos_sim = cos_sim
                final_index = i
                
        if max_cos_sim < 0.7: 
            return None
                
        return final_index
    
    
    def get_answer(self, question: str) -> str:
        
        best_index = self.most_similar(question)

        if best_index is None:
            return ERROR_MESSAGE

        return self.datas['train'][best_index]['upvoted_answer']
    

