import streamlit as st
import tensorflow as tf
import numpy as np
from PIL import Image
import tensorflow_addons as tfa

import tensorflow as tf
from tensorflow.keras.utils import custom_object_scope

# Define a function to create the InstanceNormalization layer
def create_in():
    return tfa.layers.InstanceNormalization()


def model_out(model_path,img):
  with custom_object_scope({'InstanceNormalization': create_in}):
    model = tf.keras.models.load_model(model_path)
  img = (img-127.5)/127.5
  img = np.expand_dims(img, 0)
  pred = model.predict(img)
  pred = np.asarray(pred)
  return pred[0]

st.title("Image to Monet painting cyclegan")
face_input = st.file_uploader("Image input")

if face_input is not None:
  img = Image.open(face_input)
  img = img.resize((256, 256))
  img = np.array(img)
  pred = model_out('photo2monet2.h5', img)
  st.image(img, caption="Uploaded Image")
  st.image(((pred + 1) * 127.5).astype(np.uint8), caption="Generated Monet Painting")

st.header('Which architecture did I use architecture, Resnet-Blocks or Unet architecture?')
st.write('I have tried both Resnet and unet architecture but the Resnet architecture producted black patches and did not work quite well')
st.write('But when using the Unet architecture, it produce more "Monet-ish" images')
st.write('I use the pix2pix generator from tensorflow examples module and same for the discriminator')
st.header('What datasets did you use to train your CycleGAN model?')
st.write('For the dataset, I used Monet2Photo architecture available on kaggle')
st.header('What hardware I trained it on?')
st.write('I trained the model on Kaggle notebook on P100 gpu with 13 gigs of ram cuz my pc wouldnt be in a good state if I trained the cyclegan model on Intel HD')
st.header('How much time did it take')
st.write('It took aboul 20-30 epochs each of 150 seconds, DO THE MATH')
st.write('I could have trained it for longer, But it started producing images same to the original images which were not "Monet-ish"')
st.header('Why did I make this model?')
st.subheader('I made this model to extend my experience but mostly for FUNN!!!!')
st.write("-------------------------------------------------")