import streamlit as st
import tensorflow as tf
import numpy as np
from PIL import Image
import tensorflow_addons as tfa
import cv2
import tensorflow as tf
from tensorflow.keras.utils import custom_object_scope

# Define a function to create the InstanceNormalization layer
def create_in():
    return tfa.layers.InstanceNormalization()


def model_out(model_path,img):
  with custom_object_scope({'InstanceNormalization': create_in}):
    model = tf.keras.models.load_model(model_path)
  img = (img-127.5)/127.5
  img = np.expand_dims(img, 0)
  pred = model.predict(img)
  pred = np.asarray(pred)
  return pred[0]

st.title("GrayScale to Colorized Image Pix2Pix")
day_inp = st.file_uploader("Grayscale image input")

if day_inp is not None:
  file_bytes = day_inp.read()
  img = cv2.imdecode(np.frombuffer(file_bytes, np.uint8), cv2.IMREAD_GRAYSCALE)
  img = cv2.resize(img, (256, 256))
  img = cv2.cvtColor(img, cv2.COLOR_GRAY2RGB)
  img = np.array(img)
  pred = model_out('colorizer.h5', img)
  st.image(img, caption="Uploaded Image")
  st.image(((pred + 1) * 127.5).astype(np.uint8), caption="Generated Colorized Painting")
