import streamlit as st
import tensorflow as tf
import numpy as np
from PIL import Image
import tensorflow_addons as tfa

import tensorflow as tf
from tensorflow.keras.utils import custom_object_scope

# Define a function to create the InstanceNormalization layer
def create_in():
    return tfa.layers.InstanceNormalization()


def model_out(model_path,img):
  with custom_object_scope({'InstanceNormalization': create_in}):
    model = tf.keras.models.load_model(model_path)
  img = (img-127.5)/127.5
  img = np.expand_dims(img, 0)
  pred = model.predict(img)
  pred = np.asarray(pred)
  return pred[0]

st.title("Face to Anime cyclegan")
face = st.file_uploader("face image input")

if face is not None:
  img = Image.open(face)
  img = img.resize((256, 256))
  img = np.array(img)
  pred = model_out('anime_to_face2.h5', img)
  st.image(img, caption="Uploaded Image")
  st.image(((pred + 1) * 127.5).astype(np.uint8), caption="Generated Anime image")


st.header('Which architecture did I use architecture, Resnet-Blocks or Unet architecture?')
st.write('I have used ResNet architecture')
st.header('Problems:')
st.write('Sometimes(most of the times) generates cursedimages')

st.header('What hardware I trained it on?')
st.write('I trained the model on Kaggle notebook on P100 gpu with 13 gigs of ram cuz my pc wouldnt be in a good state if I trained the cyclegan model on Intel HD')
st.header('Why did I make this model?')
st.subheader('I made this model to extend my experience but mostly for FUNN!!!!')
st.write("-------------------------------------------------")