import gradio as gr
import transformers
import youtube_transcript_api
from transformers import pipeline
from youtube_transcript_api import YouTubeTranscriptApi
from datasets import Dataset

summarizer = pipeline("summarization",model="facebook/bart-large-cnn")

def greet(link):
  try:
      unique_id = link.split("=")[-1]
      sub = YouTubeTranscriptApi.get_transcript(unique_id)  
      subtitle = " ".join([w['text'] for w in sub])
      summary = summarizer(subtitle, max_length=180, min_length=30, do_sample=False)
      return summary[0]['summary_text']
  except:
      return 'Invalid URL'

demo=gr.Interface(fn=greet, inputs="text", outputs="text")

if __name__ == "__main__":
    demo.launch()