__all__ = ['pet_wild', 'learn', 'classify_image', 'categories', 'image', 'label', 'examples', 'intf']

from fastai.vision.all import *
import gradio as gr

def pet_wild(x): return x[0].isupper()

learn = load_learner('export.pkl')

categories = ("Domestic", "Wild")

def classify_image(img):
    pred, idx, probs = learn.predict(img)
    return dict(zip(categories, map(float, probs)))

image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()
examples = ['lion_head.jpg', 'tan_bun.jpg', 'wild_bun.jpg']

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)

intf.launch(inline=False)