import streamlit as st
import plotly.figure_factory as ff
import matplotlib, matplotlib.pyplot as pl
import shap
import pandas as pd
import os

#import profiling capability
import pandas_profiling
from streamlit_pandas_profiling import st_profile_report

#ML stuff
from pycaret.classification import *
#from pycaret.regression import setup, compare_models, pull, save_model, load_model

if os.path.exists("sourcedata.csv"):
   df = pd.read_csv("sourcedata.csv", index_col=None)

with st.sidebar:
  st.image("https://www.onepointltd.com/wp-content/uploads/2020/03/inno2.png")
  st.title("Tabular_ML")
  choice = st.radio("Navigation", ["Upload", "Profiling", "Modelling", "Analyse", "Download"])
  st.info("This application allows you to build an automated ML pipeline using Streamlit, Panadas Profiling and PyCaret.")
  
if choice == "Upload":
  st.title("Upload Your Data for Modelling!")
  file = st.file_uploader("Upload Your Dataset Here")
  if file:
    df = pd.read_csv(file, index_col=None)
    df.to_csv("sourcedata.csv", index=None)
    st.dataframe(df)
  
if choice == "Profiling":
  st.title("Automated Exploratory Data Analysis")
  #profile_report = df.profile_report()
  #st_profile_report(profile_report)
  st_profile_report(pandas_profiling.ProfileReport(df))
  
if choice == "Modelling": 
    chosen_target = st.selectbox('Choose the Target Column', df.columns)
    if st.button('Run Modelling'): 
        setup(df, target=chosen_target, silent=True)
        setup_df = pull()
        #st.dataframe(setup_df)
        best_model = compare_models(include = ['rf','et', 'dt', 'lightgbm'])
        compare_df = pull()
        st.dataframe(compare_df)
        save_model(best_model, 'best_model')
        
if choice == "Analyse":
    st.title("Correlation Analysis")
    best_model = load_model('best_model') 
    train_pipe = best_model[:-1].transform(df)
    explainer = shap.TreeExplainer(best_model.named_steps["trained_model"])
    shap_values = explainer.shap_values(train_pipe)
    pl.title('Assessing feature importance based on Shap values')
    shap.summary_plot(shap_values,df,plot_type="bar",show=False)
    st.pyplot(bbox_inches='tight')
    pl.clf()
    #st.pyplot(shap.force_plot(explainer.expected_value[0], shap_values[0]))
    #shap.force_plot(explainer.expected_value, shap_values, train_pipe)
    #st.write(interpret_model(train_pipe, plot = 'correlation'))
    
    #chosen_target = st.selectbox('Choose the Target Column', df.columns)
    #if st.button('Run Modelling'): 
    #    setup(df, target=chosen_target, silent=True)
    #    setup_df = pull()

    # creating a model
    #    xgboost = create_model('xgboost')

    # interpret model
    #    st.write(interpret_model(xgboost,, plot = 'correlation'))
        #st.plotly_chart(interpret_model(xgboost), use_container_width=True)
    
    #chosen_target = st.selectbox('Choose the Target Column', df.columns)
    #if st.button('Run xgboost Modelling Analysis'): 
  #chosen_target = st.selectbox('Choose the Target Column', df.columns)
  # creating a model
        #setup(df, target=chosen_target, silent=True)
        #xgboost = create_model('xgboost')
        #interpret model
     
          
  
if choice == "Download":
  pass