from gpt_index import SimpleDirectoryReader, GPTListIndex, GPTSimpleVectorIndex, LLMPredictor, PromptHelper
from langchain import OpenAI
import gradio as gr
import sys
import os

#os.environ["OPENAI_API_KEY"]

def construct_index(directory_path):
    max_input_size = 4096
    num_outputs = 512
    max_chunk_overlap = 20
    chunk_size_limit = 600

    prompt_helper = PromptHelper(max_input_size, num_outputs, max_chunk_overlap, chunk_size_limit=chunk_size_limit)

    llm_predictor = LLMPredictor(llm=OpenAI(temperature=0.7, model_name="gpt-4", max_tokens=num_outputs))

    documents = SimpleDirectoryReader(directory_path).load_data()

    index = GPTSimpleVectorIndex(documents, llm_predictor=llm_predictor, prompt_helper=prompt_helper)

    index.save_to_disk('index.json')

    return index

def chatbot(input_text, api_token):
    if api_token != os.environ["API_TOKEN"]:
        return 'API_TOKEN does not match'
    index = GPTSimpleVectorIndex.load_from_disk('index.json')
    response = index.query(input_text, response_mode="tree_summarize")
    return response.response

iface = gr.Interface(fn=chatbot,
                     inputs=[gr.inputs.Textbox(lines=1, label="Ask Shirley"), gr.inputs.Textbox(lines=1, label="API_TOKEN")],
                     outputs="text",
                     title="Ask Shirley Anything")

index = construct_index("docs")
iface.launch()