import gradio as gr
from fastai.vision.all import *
from fastai.learner import *

learn = load_learner('model_upd.pkl')
labels = learn.dls.vocab


def predict(img):
    img = PILImage.create(img).to_thumb(512, 512)
    pred, pred_idx, probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}


gr.Interface(
    fn=predict,
    inputs=gr.inputs.Image(shape=(512, 512)),
    outputs=gr.outputs.Label(num_top_classes=3)
).launch()


