import pandas as pd
import numpy as np
import streamlit as st
import easyocr
import PIL
from PIL import Image, ImageDraw
from matplotlib import pyplot as plt


# main title
st.set_page_config(layout="wide")
st.title("Get text from image with EasyOCR") 
# subtitle
st.markdown("## EasyOCRR with Streamlit")
col1, col2 = st.columns(2)
uploaded_file = col1.file_uploader("Upload your file here ",type=['png','jpeg','jpg'])
if uploaded_file is not None:
    col1.image(uploaded_file) #display
        #print("GOGO ",type(uploaded_file))
    image = Image.open(uploaded_file)
    reader = easyocr.Reader(['tr','en'], gpu=False) 
    result = reader.readtext(np.array(image),paragraph=True)  # turn image to numpy array
        #print(len(result))
    result_text = "\n\n".join([item[1] for item in result])
    col2.markdown(result_text)