import streamlit as st
import cv2
import numpy as np
from PIL import Image

def warp_perspective(image, points):
    # Input and output dimensions
    w, h = 300, 400  # You can adjust this based on the desired output size
    input_pts = np.array(points, dtype=np.float32)
    output_pts = np.array([[0, 0], [w, 0], [w, h], [0, h]], dtype=np.float32)
    
    # Compute perspective matrix and warp the image
    matrix = cv2.getPerspectiveTransform(input_pts, output_pts)
    warped_img = cv2.warpPerspective(image, matrix, (w, h))
    
    return warped_img

st.title("Custom Shape Cropping & Perspective Correction")

uploaded_file = st.file_uploader("Upload an image", type=["jpg", "jpeg", "png"])

# Provide a placeholder for the user to input 4 vertices
points = []
for i in range(4):
    coords = st.text_input(f"Enter point {i+1} (format: x,y)", "")
    x, y = map(int, coords.split(',')) if ',' in coords else (0, 0)
    points.append([x, y])

if uploaded_file and len(points) == 4:
    image = Image.open(uploaded_file).convert('RGB')
    image_np = np.array(image)
    
    corrected_image = warp_perspective(image_np, points)
    
    st.image(corrected_image, caption='Corrected Image.', channels="BGR", use_column_width=True)
