import streamlit as st
from PIL import Image
import os
import easyocr
import numpy as np
import fitz  # PyMuPDF
import io
from pdf2image import convert_from_bytes

models_dir = "./models"
output_dir = "./output"
dirs = [models_dir, output_dir]
for d in dirs:
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

font_path = models_dir + "/Ubuntu-Regular.ttf"
reader = easyocr.Reader(
    ['en'],
    gpu=True,
    recog_network='best_norm_ED',
    detect_network="craft",
    user_network_directory=models_dir,
    model_storage_directory=models_dir,
)  # this needs to run only once to load the model into memory

# main title
st.set_page_config(layout="wide")
st.title("Сурет немесе пдф файлдан текст алу")
# subtitle
st.markdown("## Qazaq OCR")
uploaded_file = st.file_uploader("Өз файлыңызды осында жүктеңіз ('png', 'jpeg', 'jpg', 'pdf')", type=['png', 'jpeg', 'jpg', 'pdf'])



if uploaded_file is not None:
    if uploaded_file.type == "application/pdf":
        with st.spinner('ПДФ өңделуде ...'):
            temp_pdf_file = "./temp_pdf_file.pdf"
            with open(temp_pdf_file, "wb") as f:
                f.write(uploaded_file.read())

            # Now open the temporary file with fitz
            pdf_document = fitz.open(temp_pdf_file)
            total_pages = len(pdf_document)
            for page_num in range(total_pages):
                page = pdf_document.load_page(page_num)
                image_matrix = fitz.Matrix(fitz.Identity)
                pixmap = page.get_pixmap(matrix=image_matrix, dpi=300)
                image_data = pixmap.samples  # This is a bytes object
                image = Image.frombytes("RGB", (pixmap.width, pixmap.height), image_data)
                st.subheader(f'Бет {page_num + 1}/{total_pages}')
                st.image(image, caption=f'Бет {page_num + 1}')
                result = reader.readtext(np.array(image), paragraph=True)
                result_text = "\n\n".join([item[1] for item in result])
                st.text(result_text)
    else:
        with st.spinner('Сурет өңделуде ...'):
            image = Image.open(uploaded_file)
            st.image(image)
            result = reader.readtext(np.array(image), paragraph=True)
            result_text = "\n\n".join([item[1] for item in result])
        st.text(result_text)
