import streamlit as st
import json
import numpy as np
from pathlib import Path
from src.fcgr import FCGR
from src.preprocessing import Pipeline
from src.utils import clean_seq
# fcgr = FCGR(k=6)
# order_output = ['S','L','G','V','GR','GH','GV','GK','GRY','O','GRA']
# model = loader("resnet50_6mers", 11, "trained-models/model-34-0.954.hdf5")

with open("trained-models/preprocessing.json") as fp:
    pipe = json.load(fp)
    preprocessing = Pipeline(pipe)

def predict_single_seq(seq, fcgr, model):
    "Given a sequence, returns output vector with probabilities to each class"
    array = fcgr(clean_seq(seq))
    array = preprocessing(array)
    pred = model.predict(np.expand_dims(np.expand_dims(array,axis=0),axis=-1))[0]
    return pred

def process_output(output, labels):
    """Given the output probabilities and labels for each output, return the 
    label with the highest score/probability and the score
    """
    argmax = output.argmax()
    return labels[argmax], output[argmax]
