import openai

def is_string(input):
    return isinstance(input, str)

def ai_function(Question, Scene, model = "gpt-4"):
    system_message = {
        "role": "system",
        "content": (
            "You are an AI that assists the blind"
        )
    }
    user_message = {
        "role": "user",
        "content": (
            "Model, I need your assistance. I am developing a tool that can help blind people "
            "navigate their surroundings safely by offering detailed and relevant descriptions. "
            "These descriptions will be ranked using the CLIP model. "
            "The initial scene description from the blind person's perspective is: " + Scene + 
            ". "
            "And the blind person asked: " + Question +
            ". "
            "I need you to generate five sets of short, specific and actionable phrases or sentences that address the blind person's question first, "
            "and also accurately reflect the Scene. "
            "These descriptions must prioritize safety and accessibility, offering information about potential obstacles or hazards. "
            "They should serve as a practical guide for the blind, so they should be as detailed and vivid as possible. "
            "All descriptions should adhere to the context provided by the initial Scene and the blind person's question. "
            "Please provide these five sets of descriptions directly, all in English, "
            "and without any redundant information. Thank you for your assistance."
        )
    }

    if is_string(model) == False:
        return model(user_message["content"])

    messages = [system_message, user_message]
    
    response = openai.ChatCompletion.create(
        model=model,
        messages=messages,
        temperature=0.2,
        max_tokens=200,
    )
    
    return response.choices[0].message["content"]