from fastai.vision import *
from fastai.imports import *
from fastai.learner import *
from fastai.vision.all import *

import streamlit as st
import numpy as np
import matplotlib.image as mpimg
import os
import time
from PIL import Image
import requests
from io import BytesIO
import pathlib


# st.set_page_config(layout="wide")


#for windows deployment
# temp = pathlib.PosixPath
# pathlib.PosixPath = pathlib.WindowsPath


#For linux deployment
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath


path = Path('.')

with open('style.css') as f:
    st.markdown(f'<style>{f.read()}</style>', unsafe_allow_html=True)



#------Create/Define all functions

def load_model():
    model = load_learner(path/'waste_model.pkl')
    return model

model = load_model()

def display_image(display_img):
    st.image(display_img, width=400)
    # use_column_width=True
    

def make_pred(model, img):
  
    # Temporarily displays a message while executing 
    with st.spinner('Classifying, Please Wait...'):
        time.sleep(1)
        
    pred, pred_idx, prob = model.predict(img)
    pred_prob = f'{prob[pred_idx]*100:.0f}%'
    
    # Display the prediction
    if pred == 'R':
        pred_state = 'The Image is a Recyclable Waste'

    else:
        pred_state = 'The image is an organic waste'
        
    return pred_state, pred_prob
    

########--------Setup Diagnosis Page--------########

# if selected_nav == 'Diagnosis':

    ########-------Create Side Bar---------########

# st.sidebar.image('wms.jpg')
#For image upload
img_upload = st.sidebar.file_uploader(label = 'Upload a Waste Image for Classification', 
                        type=['png', 'jpg', 'jpeg'])

# For image selection
test_images = os.listdir(path/'sample')
img_selected = st.sidebar.selectbox(
        'Please Select a Waste Image:', test_images)


if img_selected:
    # Read the image
    file_path = path/'sample'/img_selected
    # Get the image to display
    display_img = Image.open(file_path)
    # display_img = display_img.resize((244,224))
    img = PILImage.create(file_path)


if img_upload:
    display_img = Image.open(img_upload)
    img = PILImage.create(img_upload)


st.markdown("""
<h3 style="text-align:center;color:#006ef5;">Waste Classification System (DEMO)</h3>
""", unsafe_allow_html=True)

st.markdown("##")


st.markdown("""
<p> <b>Instruction:</b> Please upload a waste image (using the sidebar) for classification or select a sample image</p>
""", unsafe_allow_html=True)

with st.container():
    
    display_image(display_img)

waste_prediction_output = ""

st.markdown("##")

if st.button('Classify Waste'):
    waste_prediction, pred_prob = make_pred(model, img)
    waste_prediction_output = f"{waste_prediction}, With a {pred_prob} Confidence"

st.success(waste_prediction_output)

st.markdown("##")