from fastcore.all import *
from fastai.vision.all import *

import pathlib
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath

learn = load_learner('./fast_ai_model_resnet18_new_labeling.pth')


import cv2
import torch
import torchvision.transforms as tt
import numpy as np
# from facenet_pytorch import MTCNN
from PIL import Image
import numpy as np

from retinaface import RetinaFace




device = torch.device('cuda:0' if torch.cuda.is_available() else 'cpu')

def load_checkpoint(filepath):
    checkpoint = torch.load(filepath, device)
    model = checkpoint['model']
    model.load_state_dict(checkpoint['state_dict'], strict=False)
    for parameter in model.parameters():
        parameter.requires_grad = False

    model.eval()
    return model


# filepath = './models/9.pth'
# loaded_model = load_checkpoint(filepath)

loaded_model = learn

class FaceDetector(object):
    """
    Face detector class
    """

    def __init__(self, detector,loaded_model,image=None):
        self.detector = detector
        self.loaded_model=loaded_model
        self.image = image

    def _draw(self, frame, boxes, probs, landmarks):
        """
        Draw landmarks and boxes for each face detected
        """
        try:
            for box, prob, ld in zip(boxes, probs, landmarks):
                # Draw rectangle on frame
                box = box.astype('int')
                ld = ld.astype('int')
                cv2.rectangle(frame,
                              (box[0], box[1]),
                              (box[2], box[3]),
                              (0, 0, 255),
                              thickness=2)

                # Show probability
                cv2.putText(frame, str(
                    prob), (box[2], box[3]), cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 0, 255), 2, cv2.LINE_AA)

                # Draw landmarks
                cv2.circle(frame, tuple(ld[0]), 5, (0, 0, 255), -1)
                cv2.circle(frame, tuple(ld[1]), 5, (0, 0, 255), -1)
                cv2.circle(frame, tuple(ld[2]), 5, (0, 0, 255), -1)
                cv2.circle(frame, tuple(ld[3]), 5, (0, 0, 255), -1)
                cv2.circle(frame, tuple(ld[4]), 5, (0, 0, 255), -1)
        except Exception as e:
            # print(e)
            pass

        return frame

    # def _capture(self,frame,boxes,probs,landmarks):
    #     sampleNum = 0
    #     while True:   
    #         try:
    #             sampleNum = sampleNum+1
    #             boxes = boxes.astype('int')
    #             face = frame[boxes[0,1]:boxes[0,3],boxes[0,0]:boxes[0,2]]
    #             cv2.imwrite(str(sampleNum) + ".jpg",face)                    
    #         except Exception as e:
    #             # print(e)
    #             pass
    #         if sampleNum >2:
    #             break


    def _recognize(self,loaded_model,frame,boxes):
        try:
            
            for box in boxes:
                # box = box.astype('int')
                # face = frame[box[0][1]:box[0][3],box[0][0]:box[0][2]]
                face = frame[box[1]:box[3],box[0]:box[2]]
                # pil_image = Image.fromarray(face, mode="RGB")

                labels,_,probs = loaded_model.predict(face)
                # label= 1

                
                

                label = labels if (probs[np.argmax(probs)] > 0.8) else "Unknown"
                probs = probs[np.argmax(probs)] if (probs[np.argmax(probs)] > 0.8) else np.nan

                # if prediction == 0:
                #     label = "Fadli"
                # elif prediction == 1:
                #     label = "Aziz"
                # elif prediction == 2:
                #     label = "Eka"
                # else:
                #     label = "Unknown"
                _ = "" if probs == np.nan else ": {:.2f}".format(float(probs))

                cv2.putText(frame, label + _ , (box[2], box[3]), cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 0, 255), 2, cv2.LINE_AA)

                # cv2.putText(frame,str(["{:.2f}".format(x)for x in probs]), (box[2]-100, box[3]+30), cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 0, 255), 2, cv2.LINE_AA)

                # cv2.putText(frame,"{:.2f}".format(float(probs[np.argmax(probs)])), (box[2]-100, box[3]+30), cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 0, 255), 2, cv2.LINE_AA)




                cv2.rectangle(frame,
                              (box[0], box[1]),
                              (box[2], box[3]),
                              (0, 0, 255),
                              thickness=2)
                # cv2.putText(frame, str(
                #     prediction), (box[0][2], box[0][3]), cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 0, 255), 2, cv2.LINE_AA)
            return frame
        except Exception as e:
            print(e,'eaea')
            pass
    
    def run_on_image(self,image):
        frame = image
        try:
            # detect face box, probability and landmarks
            json_face = self.detector.detect_faces(frame)

            # boxes = [json_face['face_{}'.format(x)]['facial_area'] for x in range(1,len(json_face)+1)]
            # probs = ["{:.2f}".format(json_face['face_{}'.format(x)]['score']) for x in range(1,len(json_face)+1)]
            # landmarks = [json_face['face_{}'.format(x)]['landmarks'] for x in range(1,len(json_face)+1)]

            boxes = []
            probs = []
            landmarks = []
            for key, value in json_face.items():
                boxes.append(value['facial_area'])
                probs.append("{:.2f}".format(value['score']))
                landmarks.append(value['landmarks'])
            
            return Image.fromarray(self._recognize(loaded_model,frame,boxes))
            # self._draw(frame, boxes, probs, landmarks)
            
        except Exception as e:
            print(e)
            pass


    def run(self):
        """
            Run the FaceDetector and draw landmarks and boxes around detected faces
        """
        cap = cv2.VideoCapture(0)

        while True:
            ret, frame = cap.read()
            try:
                # detect face box, probability and landmarks
                json_face = self.detector.detect_faces(frame)

                # boxes = [json_face['face_{}'.format(x)]['facial_area'] for x in range(1,len(json_face)+1)]
                # probs = ["{:.2f}".format(json_face['face_{}'.format(x)]['score']) for x in range(1,len(json_face)+1)]
                # landmarks = [json_face['face_{}'.format(x)]['landmarks'] for x in range(1,len(json_face)+1)]

                boxes = []
                probs = []
                landmarks = []
                for key, value in json_face.items():
                    boxes.append(value['facial_area'])
                    probs.append("{:.2f}".format(value['score']))
                    landmarks.append(value['landmarks'])

                self._recognize(loaded_model,frame,boxes)
                # self._draw(frame, boxes, probs, landmarks)
                
            except Exception as e:
                print(e)
                pass

            # Show the frame
            cv2.imshow('Face Detection', frame)

            if cv2.waitKey(1) & 0xFF == ord('q'):
                break

        cap.release()
        cv2.destroyAllWindows()
        
        
# Run the app

# fcd = FaceDetector(RetinaFace,loaded_model)
detector = RetinaFace
# fcd = FaceDetector(detector,loaded_model)
# fcd.run()

fcd = FaceDetector(detector,loaded_model)

import gradio as gr

gr.Interface(fn=fcd.run_on_image, 
             inputs=gr.Image(),
             outputs=gr.Image(),
             ).launch()
