import pandas as pd
import gradio as gr

df = pd.read_csv('./match_up_impact.csv')

def filter_dataframe(batter, bowler):
    batter_mask = df['Batter'].str.contains(batter, case=False, na=False)
    bowler_mask = df['Bowler'].str.contains(bowler, case=False, na=False)
    filtered_df = df[batter_mask & bowler_mask]
    return filtered_df

iface = gr.Interface(
    fn=filter_dataframe,
    inputs=[
        gr.Textbox(label="Enter Batter last Name", type="text"),
        gr.Textbox(label="Enter Bowler last Name", type="text")
    ],
    outputs=gr.Dataframe(type='pandas'),
    live=True,
    capture_session=True,
    title="Cricket Stats",
    description="Enter Batter and Bowler names to view stats."
)

iface.launch()
