from transformers import AutoTokenizer, AutoModelForCausalLM
import torch
import gradio as gr

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

def text_generation(input_text, seed):
  input_ids = tokenizer(input_text, return_tensors="pt").input_ids
  torch.manual_seed(seed) # Max value: 18446744073709551615
  outputs = model.generate(input_ids, do_sample=True, max_length=500)
  generated_text = tokenizer.batch_decode(outputs, skip_special_tokens=True)
  return generated_text

title = "Text Generator Demo GPT2"
description = "Text Generator Application by ecarbo"

gr.Interface(
    text_generation,
    [gr.inputs.Textbox(lines=2, label="Enter input text"), gr.inputs.Number(default=10, label="Enter seed number")],
    [gr.outputs.Textbox(type="auto", label="Text Generated")],
    title=title,
    description=description,
    theme="huggingface"
).launch()