import os
os.system("git clone https://github.com/google-research/frame-interpolation")
import sys
sys.path.append("frame-interpolation")
import numpy as np
import tensorflow as tf
import mediapy
from PIL import Image
from eval import interpolator, util
import gradio as gr

from huggingface_hub import snapshot_download

from image_tools.sizes import resize_and_crop


model = snapshot_download(repo_id="akhaliq/frame-interpolation-film-style")

interpolator = interpolator.Interpolator(model, None)

ffmpeg_path = util.get_ffmpeg_path()
mediapy.set_ffmpeg(ffmpeg_path)

def resize(width,img):
  basewidth = width
  img = Image.open(img)
  wpercent = (basewidth/float(img.size[0]))
  hsize = int((float(img.size[1])*float(wpercent)))
  img = img.resize((basewidth,hsize), Image.ANTIALIAS)
  return img
  

def resize_img(img1,img2):
 img_target_size = Image.open(img1)
 img_to_resize = resize_and_crop(
     img2, 
     (img_target_size.size[0],img_target_size.size[1]), #set width and height to match img1
     crop_origin="middle"
     )
 img_to_resize.save('resized_img2.png')
    
def predict(frame1, frame2, times_to_interpolate):
   
    frame1 = resize(512,frame1)
    frame2 = resize(512,frame2)

    frame1.save("test1.png")
    frame2.save("test2.png")

    resize_img("test1.png","test2.png")
    input_frames = ["test1.png", "resized_img2.png"]

    frames = list(
        util.interpolate_recursively_from_files(
            input_frames, times_to_interpolate, interpolator))

    mediapy.write_video("out.mp4", frames, fps=15)
    return "out.mp4"
article=""
description="Using AI to guess the frames between two separate images."
title="Frame Interpolation"
examples=[['cat3.jpeg','cat4.jpeg',2]]
gr.Interface(predict,[gr.inputs.Image(type='filepath'),gr.inputs.Image(type='filepath'),gr.inputs.Slider(minimum=2,maximum=8,step=1)],"playable_video",title=title,description=description,article=article,examples=examples).launch(enable_queue=True)
