from pprint import pprint
import gradio as gr
from data import Data

data = Data("./demo_data.toml")

with gr.Blocks(theme="freddyaboulton/dracula_revamped", css=data.assets["css"]) as demo:
    with gr.Column():
        gr.HTML(data.assets["header"])
        with gr.Row():
            with gr.Column(variant="panel"):
                data.render("image")
                with gr.Accordion("Advanced Settings", open=False):
                    with gr.Tabs():
                        with gr.Tab("General"):
                            with gr.Group():
                                lang_shadow_api = gr.Dropdown(
                                    [
                                        l.split(" ")[-1][1:-1]
                                        for l in data.inputs["lang"].choices
                                    ],
                                    value=[
                                        l.split(" ")[-1][1:-1]
                                        for l in data.inputs["lang"].value
                                    ],
                                    visible=False,
                                )
                                data.render("lang")
                                with gr.Row():
                                    data.render("decoder", "beamWidth")
                                data.render("allowlist", "blocklist")
                                with gr.Row():
                                    data.render("paragraph", "detail")
                                data.render(
                                    "min_size", "rotation_info", "output_format"
                                )
                        with gr.Tab("Contrast"):
                            with gr.Group():
                                data.render(
                                    "contrast_ths",
                                    "adjust_contrast",
                                )
                        with gr.Tab("Text Detection"):
                            with gr.Group():
                                data.render(
                                    "text_threshold",
                                    "low_text",
                                    "link_threshold",
                                    "mag_ratio",
                                    "threshold",
                                    "bbox_min_score",
                                    "bbox_min_size",
                                    "max_candidates",
                                )
                        with gr.Tab("Bounding Box Merging"):
                            with gr.Group():
                                gr.HTML(
                                    "<p style='margin: var(--block-padding);text-align: center;'>This set of parameter controls when adjacent bounding boxes merge with each other. Every parameters except 'Slope threshold' is in the unit of box height"
                                )
                                data.render(
                                    "slope_ths",
                                    "ycenter_ths",
                                    "height_ths",
                                    "width_ths",
                                    "add_margin",
                                    "y_ths",
                                    "x_ths",
                                )
                with gr.Row():
                    btn_clear = gr.ClearButton(
                        [data.inputs["image"], *data.outputs_list], value="Reset"
                    )
                    btn_run = gr.Button("Run!", variant="primary")
                gr.Examples(
                    examples=data.examples,
                    elem_id="examples",
                    inputs=data.inputs_list,
                    outputs=data.outputs_list,
                    fn=Data.process_image,
                    cache_examples=False,
                )
            with gr.Column(variant="panel"):
                data.render("image_out")
                with gr.Tabs():
                    with gr.Tab("Data"):
                        data.render("data_out")
                    with gr.Tab("Raw"):
                        data.render("raw_out")
        gr.HTML(data.assets["footer"])

    data.inputs["lang"].change(
        fn=lambda v: [l.split(" ")[-1][1:-1] for l in v],
        inputs=data.inputs["lang"],
        outputs=lang_shadow_api,
        api_name=False,
    )

    btn_run.click(
        fn=data.process_image,
        inputs=[lang_shadow_api, *data.inputs_list[1:]],
        outputs=data.outputs_list,
        scroll_to_output=True,
    )
    data.inputs["decoder"].select(
        lambda d: data.inputs["beamWidth"].update(
            interactive=True if d != "greedy" else False
        ),
        data.inputs["decoder"],
        data.inputs["beamWidth"],
        api_name=False,
    )
    data.inputs["paragraph"].select(
        lambda p: [
            data.inputs["x_ths"].update(interactive=p),
            data.inputs["y_ths"].update(interactive=p),
        ],
        data.inputs["paragraph"],
        [data.inputs["x_ths"], data.inputs["y_ths"]],
        api_name=False,
    )
    data.inputs["detail"].select(
        lambda p: data.inputs["output_format"].update(value=data.default[-1]),
        data.inputs["detail"],
        data.inputs["output_format"],
        api_name=False,
    )
    data.inputs["output_format"].select(
        lambda p: data.inputs["detail"].update(value=True),
        data.inputs["output_format"],
        data.inputs["detail"],
        api_name=False,
    )
    btn_clear.click(lambda: data.default, [], data.inputs_list, api_name=False)


demo.queue().launch()
