import face_recognition
import cv2
import gradio as gr
from PIL import Image
import numpy as np
import time

def run(image):
    image.thumbnail((1280, 1280))
    image = np.array(image)
    face_locations = face_recognition.face_locations(image, model="cnn")

    for top, right, bottom, left in face_locations:
        face_image = image[top:bottom, left:right]
        face_image = cv2.GaussianBlur(face_image, (99, 99), 30)
        image[top:bottom, left:right] = face_image
    
    return Image.fromarray(image)

if __name__ == "__main__":

    start = time.time()
    for _ in range(100):
        image = Image.open("./images/crowd.jpeg")
        _ = run(image)

    print('It took', (time.time()-start)/100, 'seconds.')