import gradio as gr
import os
#os.system("pip -qq install yoloxdetect==0.0.7")
os.system("pip -qq install yoloxdetect")
import torch
import json
import yoloxdetect2.helpers as yoloxdetect
#from yoloxdetect import YoloxDetector


# Images
torch.hub.download_url_to_file('https://github.com/ultralytics/yolov5/raw/master/data/images/zidane.jpg', 'zidane.jpg')
torch.hub.download_url_to_file('https://raw.githubusercontent.com/obss/sahi/main/tests/data/small-vehicles1.jpeg', 'small-vehicles1.jpeg')
torch.hub.download_url_to_file('https://raw.githubusercontent.com/Megvii-BaseDetection/YOLOX/main/assets/dog.jpg', 'dog.jpg')

model = yoloxdetect.YoloxDetector2('kadirnar/yolox_s-v0.1.1', 'configs.yolox_s', device="cuda", hf_model=True)

def yolox_inference(
    image_path: gr.inputs.Image = None,
    model_path: gr.inputs.Dropdown = 'kadirnar/yolox_s-v0.1.1',
    config_path: gr.inputs.Textbox = 'configs.yolox_s',
    image_size: gr.inputs.Slider = 640
):
    """
    YOLOX inference function
    Args:
        image: Input image
        model_path: Path to the model
        config_path: Path to the config file
        image_size: Image size
    Returns:
        Rendered image
    """

    #model = YoloxDetector(model_path, config_path=config_path, device="cpu", hf_model=True)
    #pred = model.predict(image_path=image_path, image_size=image_size)
    pred2 = []
    if model :
        print (image_path)
        model.torchyolo = True
        pred2 = model.predict(image_path=image_path, image_size=image_size)
        #text = "Ola"
        #print (vars(model))
        #print (pred2[0])
        #print (pred2[1])
        #print (pred2[2])
        #os.remove(image_path)

    
    tensor = {
      "tensorflow": [ 
      ]
    }

    if pred2 is not None:
        #print (pred2[3])
        for i, element in enumerate(pred2[0]):
            object = {}
            itemclass = round(pred2[2][i].item())
            object["classe"] = itemclass
            object["nome"] = pred2[3][itemclass]
            object["score"] = pred2[1][i].item()
            object["x"] = element[0].item()
            object["y"] = element[1].item()
            object["w"] = element[2].item()
            object["h"] = element[3].item()
            tensor["tensorflow"].append(object)
  
    #print(tensor)

    text = json.dumps(tensor)
    return text
        

inputs = [
    gr.inputs.Image(type="filepath", label="Input Image"),
    gr.inputs.Textbox(lines=1, label="Model Path", default="kadirnar/yolox_s-v0.1.1"),
    gr.inputs.Textbox(lines=1, label="Config Path", default="configs.yolox_s"),
    gr.inputs.Slider(minimum=320, maximum=1280, default=640, step=32, label="Image Size"),
]

outputs = gr.outputs.Image(type="filepath", label="Output Image")
title = "SIMULADOR PARA RECONHECIMENTO DE IMAGEM"

examples = [
    ["small-vehicles1.jpeg", "kadirnar/yolox_m-v0.1.1", "configs.yolox_m", 640],
    ["zidane.jpg", "kadirnar/yolox_s-v0.1.1", "configs.yolox_s", 640],
    ["dog.jpg", "kadirnar/yolox_tiny-v0.1.1", "configs.yolox_tiny", 640],
]

demo_app = gr.Interface(
    fn=yolox_inference,
    inputs=inputs,
    outputs=["text"],
    title=title,
    examples=examples,
    cache_examples=True,
    live=True,
    theme='huggingface',
)
try:
   demo_app.launch(debug=True, server_name="192.168.0.153", server_port=8081, enable_queue=True)
except:
   demo_app.close()

