import gradio as gr
import os
pkl = "all_20211108_res34.pkl"
from fastai.vision.all import *
from fastai.vision.widgets import *
import jaconv
import pathlib
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath
model_inf = load_learner(pkl)
#print(os.getcwd())
title = "きのこミニAI"
description = "615種類のきのこを判定します。日本国内で撮られた約10万枚の写真を学習に使用。食べる人ではなく学ぶ人のためのツールです。ご利用は自己責任で。最終更新日：2021/11/9"
def kinoko_uranai(img):
    replace_dic = {"_ッロウッ":" (group)","ー":""}
    result_dic = {}
    pred_class, pred_idxs, outputs = model_inf.predict(img)
    top_5_conf, i = outputs.topk(5)
    itr = 0
    classes = model_inf.dls.vocab
    result_dic = {}
    for x in i:
        kwamei = jaconv.alphabet2kata(classes[x.item()].lower())
        for k,v in replace_dic.items():
            kwamei = kwamei.replace(k,v)
        result_dic[kwamei] = str(round(top_5_conf[itr].item(),2))
        itr=itr+1
    return result_dic
outputs = gr.outputs.Label(num_top_classes=5)
iface = gr.Interface(fn=kinoko_uranai, inputs="image", outputs=outputs,title=title,description=description).launch(debug=True)