import gradio as gr
import torch
import numpy as np
import modin.pandas as pd
from PIL import Image
from diffusers import DiffusionPipeline 
from huggingface_hub import login
import os

login(token=os.environ.get('HF_KEY'))

device = "cuda" if torch.cuda.is_available() else "cpu"

pipe = DiffusionPipeline.from_pretrained("stabilityai/stable-diffusion-xl-base-0.9", add_to_git_credential=True)
pipe = pipe.to(device)
pipe.unet = torch.compile(pipe.unet, mode="reduce-overhead", fullgraph=True)

refiner = DiffusionPipeline.from_pretrained("stabilityai/stable-diffusion-xl-refiner-0.9")
refiner = refiner.to(device)
refiner.unet = torch.compile(refiner.unet, mode="reduce-overhead", fullgraph=True)

def genie (prompt, negative_prompt, scale, steps, seed):
     generator = torch.Generator(device=device).manual_seed(seed)
     int_image = pipe(prompt, negative_prompt=negative_prompt, num_inference_steps=steps, guidance_scale=scale, num_images_per_prompt=1, generator=generator, width=768, height=768, output_type="latent").images 
     image = refiner(prompt=prompt, image=int_image).images[0]
     return image
    
gr.Interface(fn=genie, inputs=[gr.Textbox(label='What you want the AI to generate. 77 Token Limit.'), gr.Textbox(label='What you Do Not want the AI-model to generate.'), gr.Slider(1, 15, 10), gr.Slider(25, maximum=50, value=25, step=1), gr.Slider(minimum=1, step=1, maximum=999999999999999999, randomize=True)], outputs='image', title="Stable Diffusion XL base 9 CPU", description="SDXL-base-9 CPU. <b>WARNING:</b> Extremely Slow. 65seconds/Iteration. Expected time to wait 25-50 minutes for an image of 25-50 iterations respectively.", article = "Code: <a href=\"https://huggingface.co/Atom007\">Atom007</a>").launch(debug=True, max_threads=80)