import gradio as gr

def generate_sequence(frames_per_second, seconds_per_prompt, *main_prompts):
    sequence_count = int(frames_per_second) * int(seconds_per_prompt)
    output = {}
    
    for prompt_index, main_prompt in enumerate(main_prompts):
        if main_prompt:  # Check if the field has information
            prompts = main_prompt.split(',')
            for i, prompt in enumerate(prompts):
                output[str(prompt_index * sequence_count + i * sequence_count)] = prompt.strip()

    return output

def stringify_output(output_dict):
    output_items = [f'"{k}": "{v}"' for k, v in output_dict.items()]
    return ',\n'.join(output_items)

frames_per_second = gr.Number(label="Frames per second")
seconds_per_prompt = gr.Number(label="Seconds per prompt")

main_prompts = [gr.Textbox(lines=2, label=f"Main prompt {i+1} (comma-separated)") for i in range(10)]

output = gr.Textbox(label="Output")

iface = gr.Interface(
    fn=lambda fps, spp, *mp: stringify_output(generate_sequence(fps, spp, *mp)),
    inputs=[frames_per_second, seconds_per_prompt, *main_prompts],
    outputs=output,
    title="Deforum Prompt Generator"
)

iface.launch()
