import gradio as gr
import pandas as pd
import numpy as np
from sklearn.model_selection import train_test_split
from tensorflow.keras.utils import to_categorical
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import Dense, Dropout

data=pd.read_csv(f"SaYoPillow.csv")

data.columns=['snoring_rate', 'respiration_rate', 'body_temperature', 'limb_movement', 'blood_oxygen',
             'eye_movement', 'sleeping_hours', 'heart_rate', 'stress_level']

stress_labels = ["Low/Normal", "Medium Low", "Medium", "Medium High", "High"]

# splitting the dataset
X_train = data.iloc[:, :8]
y_train = data['stress_level']

#model
model=Sequential()
model.add(Dense(125, activation="relu"))
model.add(Dense(125, activation="relu"))
model.add(Dense(5, "softmax"))

epochs=50
model.compile(loss='categorical_crossentropy', optimizer='adam', metrics=['accuracy'])

y_train_encoded = to_categorical(y_train)
stats = model.fit(X_train, y_train_encoded, epochs=epochs)


def predict(snoring_rate, respiration_rate, body_temperature, limb_movement, blood_oxygen,
            eye_movement, sleeping_hours, heart_rate):
    
    input_data = np.array([snoring_rate, respiration_rate, body_temperature, limb_movement, blood_oxygen,
                      eye_movement, sleeping_hours, heart_rate])

    # Reshape the input to match the model's expected shape
    input_data = np.reshape(input_data, (1, -1))
    
    # Make the prediction
    prediction = model.predict(input_data)[0]
    predicted_stress_level = stress_labels[np.argmax(prediction)]
    
    return predicted_stress_level

# Create the interface using Gradio
inputs = [
    gr.inputs.Slider(minimum=30, maximum=100, step=0.2, label="Snoring Rate"),
    gr.inputs.Slider(minimum=15, maximum=30, step=0.1, label="Respiration Rate"),
    gr.inputs.Slider(minimum=85, maximum=100, step=0.1, label="Body Temperature"),
    gr.inputs.Slider(minimum=0, maximum=20, step=0.1, label="Limb Movement"),
    gr.inputs.Slider(minimum=80, maximum=100, step=0.1, label="Blood Oxygen"),
    gr.inputs.Slider(minimum=60, maximum=110, step=0.5, label="Eye Movement"),
    gr.inputs.Slider(minimum=0, maximum=12, step=0.1, label="Sleeping Hours"),
    gr.inputs.Slider(minimum=50, maximum=100, step=1, label="Heart Rate"),
]

output = gr.outputs.Textbox(label="Predicted Stress Level")

title = "Stress Level Prediction from Sleep Patterns"
description = "Predict the stress level based on your sleep patterns. Based on dataset provided by a research on SaYoPillow - Smart Yoga Pillow"

gr.Interface(fn=predict, inputs=inputs, outputs=output, title=title, description=description).launch()
