import streamlit as st
from io import BytesIO
import base64
import os
from replicate import Client
from PIL import Image

illuse = Client(api_token=os.getenv('REPLICATE'))
model_name = "andreasjansson/illusion:75d51a73fce3c00de31ed9ab4358c73e8fc0f627dc8ce975818e653317cb919b"
example_image = "https://replicate.delivery/pbxt/hHJNV9QteKX8DK2ckkUeXsqbEIKNGFXU1fN0MJoizz3iPlOjA/output-0.png"

def generate(prompt, negative_prompt, qr_content, pattern_image, num_inference_steps, guidance_scale, width, height, seed, num_outputs, controlnet_conditioning_scale, border, qrcode_background):
    try:
        inputs = {
            'prompt': prompt,
            'negative_prompt': negative_prompt,
            'qr_code_content': qr_content,
            'num_inference_steps': num_inference_steps,
            'guidance_scale': guidance_scale,
            'width': width,
            'height': height,
            'seed': seed,
            'num_outputs': num_outputs,
            'controlnet_conditioning_scale': controlnet_conditioning_scale,
            'border': border,
            'qrcode_background': qrcode_background
        }
        if pattern_image is not None:
            image = Image.open(pattern_image)
            image_bytes = BytesIO()
            image.save(image_bytes, format='PNG')
            inputs['image'] = image_bytes

        result_uris = illuse.run(
            model_name,
            input=inputs
        )

        return result_uris

    except Exception as e:
        print(e)
        st.error(str(e))
        return

st.title("Illusion Diffusion by Aiconvert.online")
st.markdown('<style>h1{color: #191970; text-align: center;}</style>', unsafe_allow_html=True)

prompt = st.text_input("Prompt")
negative_prompt = st.text_input("Negative")

qr_content = st.text_input("QR Code Content", "https://youtube.com/")
pattern_input = st.file_uploader("Pattern Image (if used, QR Code Content won't be used)", type=["jpg", "png", "jpeg"])

st.sidebar.markdown("## Advanced Settings")

with st.sidebar.expander("Advanced Settings", expanded=True):
    num_inference_steps = st.slider("num_inference_steps", min_value=20, max_value=100, step=1, value=42)
    guidance_scale = st.slider("guidance_scale", min_value=0.1, max_value=30.0, step=0.01, value=14.5)
    width = st.slider("width", min_value=128, max_value=1024, step=8, value=768)
    height = st.slider("height", min_value=128, max_value=1024, step=8, value=768)
    seed = st.number_input("seed", value=-1)
    num_outputs = st.slider("num_outputs", min_value=1, max_value=4, step=1, value=1)
    controlnet_conditioning_scale = st.slider("controlnet_conditioning_scale", min_value=0, max_value=4, step=1, value=1)
    border = st.slider("border", min_value=0, max_value=4, step=1, value=4)
    qrcode_background = st.selectbox("qrcode_background", options=['gray', 'white'], index=1)

if st.button("Generate"):
    with st.spinner("Running..."):
        result_uris = generate(prompt, negative_prompt, qr_content, pattern_input, num_inference_steps, guidance_scale, width, height, seed, num_outputs, controlnet_conditioning_scale, border, qrcode_background)
    for uri in result_uris:
        st.image(uri)

st.image(example_image, caption='Example Image', use_column_width=True)
st.markdown("powered with ❤️ by Aiconvert.online")
