import argparse
import time
import gradio as gr
import cv2
import matplotlib.pyplot as plt
import torch
from PIL import Image
from torchvision.datasets import ImageFolder
import matplotlib.pyplot as plt
import torch.backends.cudnn as cudnn
import numpy as np
import matplotlib.pyplot as plt
import torchvision
from torchvision.transforms import transforms
import os
def class_model():
    model = torch.hub.load('pytorch/vision:v0.10.0', 'resnet101', pretrained=True)

    class LinearModel(torch.nn.Module):

        def __init__(self):
            super(LinearModel, self).__init__()
            self.activation = torch.nn.ReLU()
            self.linear1 = torch.nn.Linear(1024, 100)
            self.linear2 = torch.nn.Linear(100, 3)

        def forward(self, x):
            x = self.activation(x)
            x = self.linear1(x)
            x = self.activation(x)
            x = self.linear2(x)
            return x
    full_c = torch.nn.Linear(in_features = 2048, out_features = 1024)
    full_c.load_state_dict(torch.load('so.pt'))
    model.fc = full_c
    Linear = LinearModel()
    Linear.load_state_dict(torch.load('som.pt'))
    model = torch.nn.Sequential(model, Linear)
    model.eval()
    return model

transform = transforms.Compose([
        transforms.ToPILImage(),
        transforms.Resize((224, 224)),
        transforms.ToTensor(),
        transforms.Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
    ])

def box_iou(box1, box2):
    # https://github.com/pytorch/vision/blob/master/torchvision/ops/boxes.py
    """
    Return intersection-over-union (Jaccard index) of boxes.
    Both sets of boxes are expected to be in (x1, y1, x2, y2) format.
    Arguments:
        box1 (Tensor[N, 4])
        box2 (Tensor[M, 4])
    Returns:
        iou (Tensor[N, M]): the NxM matrix containing the pairwise
            IoU values for every element in boxes1 and boxes2
    """

    def box_area(box):
        # box = 4xn
        return (box[2] - box[0]) * (box[3] - box[1])

    area1 = box_area(box1.t())
    area2 = box_area(box2.t())

    # inter(N,M) = (rb(N,M,2) - lt(N,M,2)).clamp(0).prod(2)
    inter = (torch.min(box1[:, None, 2:], box2[:, 2:]) - torch.max(box1[:, None, :2], box2[:, :2])).clamp(0).prod(2)
    return inter / (area1[:, None] + area2 - inter)  # iou = inter / (area1 + area2 - inter)
    
def xywh2xyxy(x):
    # Convert nx4 boxes from [x, y, w, h] to [x1, y1, x2, y2] where xy1=top-left, xy2=bottom-right
    y = torch.zeros_like(x) if isinstance(x, torch.Tensor) else np.zeros_like(x)
    y[:, 0] = x[:, 0] - x[:, 2] / 2  # top left x
    y[:, 1] = x[:, 1] - x[:, 3] / 2  # top left y
    y[:, 2] = x[:, 0] + x[:, 2] / 2  # bottom right x
    y[:, 3] = x[:, 1] + x[:, 3] / 2  # bottom right y
    return y
def non_max_suppression(prediction, conf_thres=0.1, iou_thres=0.65, merge=False, classes=None, agnostic=False):
    """Performs Non-Maximum Suppression (NMS) on inference results

    Returns:
         detections with shape: nx6 (x1, y1, x2, y2, conf, cls)
    """
    if prediction.dtype is torch.float16:
        prediction = prediction.float()  # to FP32

    nc = prediction[0].shape[1] - 5  # number of classes
    xc = prediction[..., 4] > conf_thres  # candidates

    # Settings
    min_wh, max_wh = 2, 4096  # (pixels) minimum and maximum box width and height
    max_det = 300  # maximum number of detections per image
    time_limit = 10.0  # seconds to quit after
    redundant = True  # require redundant detections
    multi_label = nc > 1  # multiple labels per box (adds 0.5ms/img)

    t = time.time()
    output = [None] * prediction.shape[0]
    for xi, x in enumerate(prediction):  # image index, image inference
        # Apply constraints
        # x[((x[..., 2:4] < min_wh) | (x[..., 2:4] > max_wh)).any(1), 4] = 0  # width-height
        x = x[xc[xi]]  # confidence

        # If none remain process next image
        if not x.shape[0]:
            continue

        # Compute conf
        x[:, 5:] *= x[:, 4:5]  # conf = obj_conf * cls_conf

        # Box (center x, center y, width, height) to (x1, y1, x2, y2)
        box = xywh2xyxy(x[:, :4])

        # Detections matrix nx6 (xyxy, conf, cls)
        if multi_label:
            i, j = (x[:, 5:] > conf_thres).nonzero().t()
            x = torch.cat((box[i], x[i, j + 5, None], j[:, None].float()), 1)
        else:  # best class only
            conf, j = x[:, 5:].max(1, keepdim=True)
            x = torch.cat((box, conf, j.float()), 1)[conf.view(-1) > conf_thres]

        # Filter by class
        if classes:
            x = x[(x[:, 5:6] == torch.tensor(classes, device=x.device)).any(1)]

        # Apply finite constraint
        # if not torch.isfinite(x).all():
        #     x = x[torch.isfinite(x).all(1)]

        # If none remain process next image
        n = x.shape[0]  # number of boxes
        if not n:
            continue

        # Sort by confidence
        # x = x[x[:, 4].argsort(descending=True)]

        # Batched NMS
        c = x[:, 5:6] * (0 if agnostic else max_wh)  # classes
        boxes, scores = x[:, :4] + c, x[:, 4]  # boxes (offset by class), scores
        i = torchvision.ops.boxes.nms(boxes, scores, iou_thres)
        if i.shape[0] > max_det:  # limit detections
            i = i[:max_det]
        if merge and (1 < n < 3E3):  # Merge NMS (boxes merged using weighted mean)
            try:  # update boxes as boxes(i,4) = weights(i,n) * boxes(n,4)
                iou = box_iou(boxes[i], boxes) > iou_thres  # iou matrix
                weights = iou * scores[None]  # box weights
                x[i, :4] = torch.mm(weights, x[:, :4]).float() / weights.sum(1, keepdim=True)  # merged boxes
                if redundant:
                    i = i[iou.sum(1) > 1]  # require redundancy
            except:  # possible CUDA error https://github.com/ultralytics/yolov3/issues/1139
                print(x, i, x.shape, i.shape)
                pass

        output[xi] = x[i]
        if (time.time() - t) > time_limit:
            break  # time limit exceeded

    return output



def run_detector(img):
    device = torch.device('cpu')
    print(1)
    model = torch.load('last_yolov5s_results.pt', map_location=device)['model'].float()
    print(2)
    image = img
    res_image = cv2.resize(image, (416, 416))
    image = torch.tensor(res_image).permute(2, 0, 1).unsqueeze(0).float() / 255.
    count_dobri = 0
    count_all = 0
    with torch.no_grad():
        detection = model(image)
    pred = non_max_suppression(detection[0], conf_thres=0.4, iou_thres=0.6)
    main_model = class_model()
    main_model.eval()

    for i in pred[0]:
        if i[0] > 0 and i[1] > 0 and i[2] > 0 and i[3] > 0:
            if i[3] > i[1] and i[2] > i[0]:

                cropped_image = res_image[int(i[1]):int(i[3]), int(i[0]):int(i[2])]
                input_tensor = transform(cropped_image)
                input_tensor = input_tensor.reshape(1, 3, 224, 224)
                with torch.no_grad():
                    input = main_model(input_tensor)
                    layer = torch.nn.Softmax(dim=1)
                    output_s = layer(input)
                    output = torch.argmax(output_s)
                    print(output)
                    if output == 0 and output_s[0][0] > 0.55:
                        count_dobri +=1
                        cv2.rectangle(res_image, (int(i[0]), int(i[1])), (int(i[2]), int(i[3])), (0, 255, 0))
                    elif output == 1:
                        count_all +=1
                        cv2.rectangle(res_image, (int(i[0]), int(i[1])), (int(i[2]), int(i[3])), (0, 0, 255))
                    elif output == 2:
                        cv2.rectangle(res_image, (int(i[0]), int(i[1])), (int(i[2]), int(i[3])), (255, 0, 0))
    count_all += count_dobri
    global dobry_percent
    dobry_percent = count_dobri/count_all
    return res_image


def greet(name):
    print(type(name))
    res_image = run_detector(name)
    
    return res_image, dobry_percent*100


demo = gr.Interface(fn=greet, inputs="image", outputs=['image', 'text'])

demo.launch()